DROP PROCEDURE [hips].[StreetTypeCodeGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Philip Stalley-Gordon
-- Create date:	  13 Nov 2013	
-- Description:   Gets a list or specific record from the linkage of the StreetType Code Table
-- =============================================
CREATE PROCEDURE [hips].[StreetTypeCodeGet] 
(
	@CodeSystemCode VARCHAR(20),
	@StreetTypeId INT = NULL
)
AS
BEGIN

	SELECT  st.StreetTypeId, st.Code, st.Description
	FROM    hips.StreetTypeCode ssc
			JOIN hips.StreetType st ON ssc.StreetTypeId = st.StreetTypeId
			JOIN hips.CodeSystem cs ON ssc.CodeSystemId = cs.CodeSystemId
			WHERE cs.Code = @CodeSystemCode
			AND (st.StreetTypeId = @StreetTypeId OR @StreetTypeId IS NULL)
	ORDER BY st.Description

END
GO

